
function [systemMats, lambda] = defineFullModel(vrbs,shocks,nvar,nshock,nlag,params)

% Initialize canonical-form matrices (which we will later populate)
% Note: these matrices include extra entries for the lags, required for
% Reds-Solds. 

systemMats.A0=zeros(nvar,nvar);
systemMats.A1=zeros(nvar,nvar);
systemMats.A2=zeros(nvar,nvar);
systemMats.A3=zeros(nvar,nvar);
systemMats.A4=zeros(nvar,nvar);
systemMats.A5=zeros(nvar,nvar);
systemMats.A6=zeros(nvar,nvar);
systemMats.A7=zeros(nvar,nvar);
systemMats.A8=zeros(nvar,nshock);


%% Households
% set number of variables
households.nvar  = 4;
households.nstate= 2;

% assign indices to relevant state variables
households.c       = 1;
households.w_r     = 2;
households.w_r_lag = 3;
households.d       = 4;

households.choice={'c','w_r'};

% delta: variables outside households' control

% delta_C = households.c; delta_w = households.w_r; delta_d = households.d-1; % NOT USED

% Define Psi_0 and Psi_1 matrices
households.Psi_0 = zeros(households.nvar,households.nvar);
households.Psi_1 = zeros(households.nvar,households.nvar);

households.Psi_0(households.c, households.c)            = params.sigma / (1 - params.b*params.gamma^(-1));
households.Psi_0(households.c,households.w_r)           = params.xi_v * params.theta_w;
households.Psi_0(households.w_r,households.w_r)         = -params.xi_w^(-1) * params.beta*params.gamma^(1-params.sigma);
households.Psi_0(households.w_r_lag,households.w_r_lag) = 1;
households.Psi_0(households.d, households.d)            = 1/params.cy_ratio;

households.Psi_1(households.c, households.c)            = params.sigma / (1 - params.b*params.gamma^(-1));
households.Psi_1(households.c,households.w_r)           = params.xi_v * params.theta_w;
households.Psi_1(households.w_r, households.c)          = 1 / (1 - params.b*params.gamma^(-1));
households.Psi_1(households.w_r,households.w_r)         = -params.c_1w;
households.Psi_1(households.w_r,households.w_r_lag)     = params.xi_w^(-1);
households.Psi_1(households.w_r_lag,households.w_r)     = 1;
households.Psi_1(households.d, households.c)            = -1;
households.Psi_1(households.d, households.w_r)          = params.wc_ratio  * (1 - params.theta_w);
households.Psi_1(households.d, households.d)            = params.beta^(-1) * params.gamma^(params.sigma - 1)/params.cy_ratio;


% get decision rule
[households.Dk, households.Dd1,  households.Dd2,  households.Lambda] = getDecision(households.Psi_0, households.Psi_1, households.nstate);


% Reduce size of households.Dd2 to eliminate the third column corresponding to
% households.w_r_lag

households.Dd2 = households.Dd2(:,[1 2 4]);


households.D_lambda1=households.Dd1*[households.Dd2(1,:);zeros(1,households.nvar-1)];
households.D_lambda2=households.Dd1*[zeros(1,households.nvar-1);households.Dd2(2,:)];
lambda_1=households.Lambda(1,1);
lambda_2=households.Lambda(2,2);


% here we check the coefficient on P_m(t-1) equals zero, as this is not one
% of our state variables

identity_1 = (households.Dk(1,2) - (households.D_lambda1(1,3) + households.D_lambda2(1,3))*params.beta^(-1)*params.gamma^(params.sigma-1)/params.cy_ratio) * params.by_ratio;
identity_2 = (households.Dk(2,2) - (households.D_lambda1(2,3) + households.D_lambda2(2,3))*params.beta^(-1)*params.gamma^(params.sigma-1)/params.cy_ratio) * params.by_ratio;


if identity_1>1e-10 || identity_2>1e-10 
    error('The coefficient on P_m(t-1) does not equal zero. This is likely caused by some error in the household decision rule you have defined.');
end


for l=1:2 % loop through choice variables
%for l=1:1 % loop through choice variables; TEST: only consumption function 
    
    systemMats.A0(vrbs.(households.choice{l}), vrbs.(households.choice{l})) = 1;
    systemMats.A7(vrbs.(households.choice{l}),vrbs.w_r) = households.Dk(l,1);
    systemMats.A7(vrbs.(households.choice{l}),vrbs.b_m) = households.Dk(l,2)*params.P_m;
    
    
    for  i = 1:2 % loop through eigenvalues
        
        % get D-matrix and lambda value associated with ith eigenvector
        evalc(['D = households.D_lambda' num2str(i)]);
        evalc(['lambda = lambda_' num2str(i)]);
       
        
        
        
        % Contemporaneous terms
        
        
        %P_C (delta_C)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,1) * params.xi_v * params.theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     + D(l,1) * params.xi_v;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.c)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.c)     - D(l,1) * params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1)) * (1 - lambda^(-1));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) - D(l,1) * (params.sigma * ((1-params.rho_gamma) / (1 - params.b * params.gamma^(-1)) - params.rho_gamma));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.xi)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.xi)    - D(l,1) * (params.rho_xi - 1);
        systemMats.A7(vrbs.(households.choice{l}), vrbs.c)     = systemMats.A7(vrbs.(households.choice{l}), vrbs.c)     - D(l,1) * (params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1)));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     - D(l,1);
        
        %P_w (delta_w)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)    + D(l,2) * params.c_3w * params.theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)      + D(l,2) * params.c_3w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)     + D(l,2) * (params.xi_w^(-1) * (1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda^(-1) * params.xi_w^(-1) * params.iota_w);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)  = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)  + D(l,2) * (params.c_2w - params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma) * params.rho_gamma - lambda^(-1) * params.xi_w^(-1) * params.iota_w);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)= systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)+ D(l,2) * (1/(params.theta_w-1));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.c)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.c)      + D(l,2) * lambda^(-1) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
        systemMats.A7(vrbs.(households.choice{l}), vrbs.c)      = systemMats.A7(vrbs.(households.choice{l}), vrbs.c)      - D(l,2) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
        systemMats.A7(vrbs.(households.choice{l}), vrbs.pi)     = systemMats.A7(vrbs.(households.choice{l}), vrbs.pi)     + D(l,2) * params.xi_w ^(-1) * params.iota_w;
        systemMats.A7(vrbs.(households.choice{l}), vrbs.gamma)  = systemMats.A7(vrbs.(households.choice{l}), vrbs.gamma)  + D(l,2) * params.xi_w ^(-1) * params.iota_w;
        
        %P_d (delta_d)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.P_m)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.P_m)   - D(l,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio*params.rho*params.beta*params.gamma^(-params.sigma);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)    + D(l,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) + D(l,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   - D(l,3) * params.wc_ratio * params.theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     - D(l,3) * params.wc_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.Gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.Gamma) - D(l,3)/params.cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.tau)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.tau)   + D(l,3)/params.cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     - D(l,3)*lambda^(-1)*params.beta^(-1)*params.gamma^(params.sigma-1) * params.by_ratio / params.cy_ratio;
        
        
        % Discounted forecasts
        
        %P_C (delta_C)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)     + D(l,1)*params.sigma*params.b*params.gamma^(-1)*lambda^(-1)/(1-params.b*params.gamma^(-1))*(1-lambda^-1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma) + D(l,1)*lambda^(-1)*params.sigma*((1-params.rho_gamma)/(1-params.b*params.gamma^(-1)) - params.rho_gamma);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)    - D(l,1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,1)*params.xi_v*params.theta_w*(1-lambda^(-1));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)     + D(l,1)*(1-lambda^(-1))*params.xi_v;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.xi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.xi)    + D(l,1)*lambda^(-1)*(params.rho_xi - 1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)     + D(l,1)*lambda^(-1);
        
        %P_w (delta_w)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     - D(l,2)*lambda^(-1)*params.c_3w*params.theta_w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       - D(l,2)*lambda^(-1)*params.c_3w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       - D(l,2)*lambda^(-2)*params.b*params.gamma^(-1)/(1-params.b*params.gamma^(-1));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      - D(l,2)*(lambda^(-1)*params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda^(-2)*params.xi_w^(-1)*params.iota_w - params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   - D(l,2) * (lambda^(-1) * (params.c_2w - params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma)*params.rho_gamma) - lambda^(-2)*params.xi_w^(-1)*params.iota_w);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) - D(l,2) * lambda ^(-1)/(params.theta_w-1);
        
        %P_d (delta_d)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)     + D(l,3)*lambda^(-2)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio/params.cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)    - D(l,3)*lambda^(-1)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio/params.cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma) - D(l,3)*lambda^(-1)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio/params.cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,3)*lambda^(-1)*params.wc_ratio*params.theta_w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)     + D(l,3) *lambda^(-1)*params.wc_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.Gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.Gamma) + D(l,3) *lambda^(-1)/params.cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.tau)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.tau)   - D(l,3) *lambda^(-1)/params.cy_ratio;
        
    end
    
end

%% static wage equation (flex wages): TEST

% systemMats.A0(vrbs.w_r, vrbs.w_r) = params.c_1w + params.c_3w*params.theta_w;
% systemMats.A0(vrbs.w_r, vrbs.N) = params.c_3w;
% systemMats.A0(vrbs.w_r, vrbs.c) = -1 / (1-params.b*params.gamma^(-1));
% systemMats.A7(vrbs.w_r, vrbs.c) = - params.b*params.gamma^(-1)/ (1-params.b*params.gamma^(-1));




%% Firm's Decision Rule (capital accumulation and investment)
firms=struct;

% set number of variables
firms.nvar  = 3;
firms.nstate= 1;

% assign indices to relevant state variables
firms.i     = 1;
firms.P_k   = 2;
firms.i_lag = 3;

% Define Psi_0 and Psi_1 matrices
firms.Psi_0 = zeros(firms.nvar,firms.nvar);
firms.Psi_1 = zeros(firms.nvar,firms.nvar);

firms.Psi_0(firms.i,firms.i)          = -params.beta*params.gamma^(1-params.sigma);
firms.Psi_0(firms.P_k,firms.P_k)      = params.beta*params.gamma^(-params.sigma)*(1-params.delta);
firms.Psi_0(firms.i_lag,firms.i_lag)  = 1;

firms.Psi_1(firms.i,firms.i)          = -(1+params.beta*params.gamma^(1-params.sigma));
firms.Psi_1(firms.i,firms.P_k)        = params.xi_I;
firms.Psi_1(firms.i,firms.i_lag)      = 1;
firms.Psi_1(firms.P_k,firms.P_k)      = 1;
firms.Psi_1(firms.i_lag,firms.i)      = 1;

firms.choice={'i','P_k'};


% get decision rule
[firms.Dk, firms.Dd1, firms.Dd2, firms.Lambda] = getDecision(firms.Psi_0,firms.Psi_1,firms.nstate);


% Reduce size of firms.Dd2 to eliminate the third column corresponding to
% firms.i_lag

firms.Dd2 = firms.Dd2(:,[1 2]);



firms.D_lambda4=firms.Dd1*[firms.Dd2(1,:);zeros(1,firms.nvar-1)];
firms.D_lambda5=firms.Dd1*[zeros(1,firms.nvar-1);firms.Dd2(2,:)];
lambda_4=firms.Lambda(1,1);
lambda_5=firms.Lambda(2,2);

   
for l=1:2 % loop through choice variables
    
    systemMats.A0(vrbs.(firms.choice{l}),vrbs.(firms.choice{l}))=1;
    systemMats.A7(vrbs.(firms.choice{l}),vrbs.i)=firms.Dk(l);
    
    for i= 4:5 % loop through eigenvalues        
        
        % get D-matrix and lambda value associated with ith eigenvector
        evalc(['D=firms.D_lambda' num2str(i)]);
        evalc(['lambda=lambda_' num2str(i)]);
        
        
        %delta_I
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.mu)    = systemMats.A0(vrbs.(firms.choice{l}),vrbs.mu)     - D(l,1)*params.xi_I;
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.gamma) = systemMats.A0(vrbs.(firms.choice{l}),vrbs.gamma)  - D(l,1)*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
        
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.mu)     = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.mu)    +D(l,1)/lambda*params.xi_I;
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.gamma)  = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.gamma) +D(l,1)/lambda*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
        
        %delta_K
        systemMats.A0(vrbs.(firms.choice{l}),vrbs.R)  = systemMats.A0(vrbs.(firms.choice{l}),vrbs.R) - D(l,2);
        
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R_k) = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R_k) - D(l,2)*(1-params.beta*params.gamma^(-params.sigma)*(1-params.delta));
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R)   = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.R)   + D(l,2)/lambda;
        systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.pi)  = systemMats.(['A' num2str(i)])(vrbs.(firms.choice{l}),vrbs.pi)  - D(l,2);
    end
end


%% Bonds decision rule
lambda_6 = 1/(params.rho*params.beta*params.gamma^(-params.sigma));

systemMats.A0(vrbs.P_m,vrbs.P_m) = systemMats.A0(vrbs.P_m,vrbs.P_m) +1;
systemMats.A0(vrbs.P_m,vrbs.R)   = systemMats.A0(vrbs.P_m,vrbs.R) +1;

systemMats.A6(vrbs.P_m,vrbs.R) = systemMats.A6(vrbs.P_m, vrbs.R) - params.rho*params.beta*params.gamma^(-params.sigma);


%% Firm's decision rule (intermediate inputs)

% analytic solution: (we will use this to check that the algorithmic
% solution is correct)
lambda_3 = 1/(params.gamma_1 * params.beta * params.gamma^(1-params.sigma));

systemMats.A0(vrbs.pi, vrbs.pi)      = 1 + params.beta * params.gamma^(1-params.sigma) * params.iota_p * (1-params.gamma_1);
systemMats.A7(vrbs.pi, vrbs.pi)      = params.iota_p;
systemMats.A0(vrbs.pi, vrbs.w_r)     = - params.xi_p * (1 - params.alpha);
systemMats.A0(vrbs.pi, vrbs.R_k)     = - params.xi_p * params.alpha;
systemMats.A0(vrbs.pi, vrbs.theta_p) = params.xi_p/(params.theta_p - 1);

systemMats.A3(vrbs.pi, vrbs.w_r)     = params.xi_p*params.gamma_1*params.beta*params.gamma^(1-params.sigma)*(1-params.alpha);
systemMats.A3(vrbs.pi, vrbs.R_k)     = params.xi_p*params.gamma_1*params.beta*params.gamma^(1-params.sigma)*params.alpha;
systemMats.A3(vrbs.pi, vrbs.theta_p) = - params.xi_p*params.gamma_1*params.beta*params.gamma^(1-params.sigma) /(params.theta_p - 1);
systemMats.A3(vrbs.pi, vrbs.pi)      = params.beta*params.gamma^(1-params.sigma)*(1-params.gamma_1)*(1-params.iota_p*params.gamma_1*params.beta*params.gamma^(1-params.sigma));

% % algorithmic solution 
% firms_intermediate = struct;
% 
% %set number of variables
% firms_intermediate.nvar   = 2;
% firms_intermediate.nstate = 1;
% 
% %assign indices to relevant state variables
% firms_intermediate.P      = 1;
% firms_intermediate.P_lag  = 2;
% 
% % Define Psi_0 and Psi_1 matrices
% firms_intermediate.Psi_0 = zeros(firms_intermediate.nvar,firms_intermediate.nvar);
% firms_intermediate.Psi_1 = zeros(firms_intermediate.nvar,firms_intermediate.nvar);
% 
% firms_intermediate.Psi_0(firms_intermediate.P,firms_intermediate.P)         = -params.beta*params.gamma^(1-params.sigma);
% firms_intermediate.Psi_0(firms_intermediate.P,firms_intermediate.P_lag)     = 1 + params.xi_p + params.beta*params.gamma^(1-params.sigma);
% firms_intermediate.Psi_0(firms_intermediate.P_lag,firms_intermediate.P_lag) = 1;
% 
% firms_intermediate.Psi_1(firms_intermediate.P,firms_intermediate.P_lag)     = 1;
% firms_intermediate.Psi_1(firms_intermediate.P_lag,firms_intermediate.P)     = 1;
% 
% % get decision rule
% [firms_intermediate.Dk, firms_intermediate.Dd1, firms_intermediate.Dd2, firms_intermediate.Lambda] = getDecision(firms_intermediate.Psi_0,firms_intermediate.Psi_1,firms.nstate);
% firms_intermediate.D_lambda3=firms_intermediate.Dd1*[firms_intermediate.Dd2(1,:);zeros(1,firms_intermediate.nvar)];
% firms_intermediate.D_lambda3 = firms_intermediate.D_lambda3(1,1);
% lambda_3=firms_intermediate.Lambda(1,1);
% 
% systemMats.A0(vrbs.pi, vrbs.pi) = (1 - params.iota_p*lambda_3^(-1)+ params.beta * params.gamma^(1-params.sigma)*params.iota_p);
% systemMats.A7(vrbs.pi, vrbs.pi) = params.iota_p;
% systemMats.A0(vrbs.pi, vrbs.w_r) =  - params.xi_p * (1 - params.alpha);
% systemMats.A0(vrbs.pi, vrbs.R_k) =  - params.xi_p * params.alpha;
% systemMats.A0(vrbs.pi, vrbs.theta_p) = params.xi_p/(params.theta_p - 1);
% systemMats.A3(vrbs.pi, vrbs.pi) = -((lambda_3^(-1) - params.iota_p*lambda_3^(-2) - params.beta * params.gamma^(1-params.sigma) + params.beta*params.gamma^(1-params.sigma)*lambda_3^(-1)*params.iota_p));
% systemMats.A3(vrbs.pi, vrbs.w_r) = params.xi_p * lambda_3^(-1) * (1 - params.alpha);
% systemMats.A3(vrbs.pi, vrbs.R_k) = params.xi_p * lambda_3^(-1) * params.alpha;
% systemMats.A3(vrbs.pi, vrbs.theta_p) = -params.xi_p * lambda_3^(-1)/(params.theta_p - 1);

%% Static Equilibrium Conditions %%

%% N - Jump
systemMats.A0(vrbs.N, vrbs.R_k) = -(1 + params.F_y_ratio) * params.alpha * params.xi_a^(-1);
systemMats.A7(vrbs.N, vrbs.k) = (1 + params.F_y_ratio) * params.alpha;
systemMats.A0(vrbs.N, vrbs.gamma) = (1 + params.F_y_ratio) * params.alpha;
systemMats.A0(vrbs.N, vrbs.N) = -(1 + params.F_y_ratio)*(1-params.alpha);
systemMats.A0(vrbs.N, vrbs.y) = 1;

%% R - State
systemMats.A0(vrbs.R,vrbs.R) = 1;
systemMats.A7(vrbs.R,vrbs.R) = params.rho_i;
systemMats.A0(vrbs.R,vrbs.pistar) = -(1-params.rho_i)*(1-params.phi_pi);
systemMats.A0(vrbs.R,vrbs.pi) = -(1-params.rho_i)*params.phi_pi;
systemMats.A0(vrbs.R,vrbs.c) = -(1-params.rho_i)*params.phi_x*params.cy_ratio;
systemMats.A0(vrbs.R,vrbs.i) = -(1-params.rho_i)*params.phi_x*params.iy_ratio;
systemMats.A0(vrbs.R,vrbs.g) = -(1-params.rho_i)*params.phi_x*params.gy_ratio;
systemMats.A7(vrbs.R,vrbs.c) = -(1-params.rho_i)*params.phi_x*params.cy_ratio;
systemMats.A7(vrbs.R,vrbs.i) = -(1-params.rho_i)*params.phi_x*params.iy_ratio;
systemMats.A7(vrbs.R,vrbs.g) = -(1-params.rho_i)*params.phi_x*params.gy_ratio;
systemMats.A0(vrbs.R,vrbs.gamma) = -(1-params.rho_i)*params.phi_x;
systemMats.A0(vrbs.R,vrbs.m) = -1;

%% tau - State
systemMats.A0(vrbs.tau,vrbs.tau) = 1;
systemMats.A7(vrbs.tau,vrbs.tau) = params.rho_tau;
systemMats.A7(vrbs.tau,vrbs.b_m) = (1-params.rho_tau)*params.phi_taul*(1+params.rho*params.P_m);
systemMats.A0(vrbs.tau,vrbs.P_m) = -(1-params.rho_tau)*params.phi_taul*params.rho*params.by_ratio;
systemMats.A0(vrbs.tau,vrbs.c) = -(1-params.rho_tau)*params.phi_taux*params.cy_ratio;
systemMats.A0(vrbs.tau,vrbs.i) = -(1-params.rho_tau)*params.phi_taux*params.iy_ratio;
systemMats.A0(vrbs.tau,vrbs.g) = -(1-params.rho_tau)*params.phi_taux*params.gy_ratio;
systemMats.A7(vrbs.tau,vrbs.c) = -(1-params.rho_tau)*params.phi_taux*params.cy_ratio;
systemMats.A7(vrbs.tau,vrbs.i) = -(1-params.rho_tau)*params.phi_taux*params.iy_ratio;
systemMats.A7(vrbs.tau,vrbs.g) = -(1-params.rho_tau)*params.phi_taux*params.gy_ratio;
systemMats.A0(vrbs.tau,vrbs.gamma) = -(1-params.rho_tau)*params.phi_taux;
systemMats.A0(vrbs.tau,vrbs.tau_shock) = -1;

%% R_k - Jump
systemMats.A0(vrbs.R_k, vrbs.R_k) = (params.xi_a^(-1) + 1);
systemMats.A7(vrbs.R_k, vrbs.k) = -1;
systemMats.A0(vrbs.R_k, vrbs.N) = -1;
systemMats.A0(vrbs.R_k, vrbs.gamma) = -1;
systemMats.A0(vrbs.R_k, vrbs.w_r) = -1;

%% Gamma - Jump
systemMats.A0(vrbs.Gamma, vrbs.Gamma) = 1;
systemMats.A0(vrbs.Gamma, vrbs.y) = -1;
systemMats.A0(vrbs.Gamma, vrbs.N) =   params.cy_ratio*params.wc_ratio;
systemMats.A0(vrbs.Gamma, vrbs.w_r) = params.cy_ratio*params.wc_ratio;
systemMats.A0(vrbs.Gamma, vrbs.R_k) = params.R_K*params.gamma^-1/params.yk_ratio/params.xi_a;
systemMats.A0(vrbs.Gamma, vrbs.i)   = params.ik_ratio / params.yk_ratio;

%% b_m - State
systemMats.A0(vrbs.b_m, vrbs.b_m) = params.P_m;
systemMats.A7(vrbs.b_m, vrbs.b_m) = params.beta^(-1)*params.gamma^(params.sigma - 1)*params.P_m;
systemMats.A0(vrbs.b_m, vrbs.pi) = params.beta^(-1)*params.gamma^(params.sigma - 1)*params.by_ratio;
systemMats.A0(vrbs.b_m, vrbs.gamma) = params.beta^(-1)*params.gamma^(params.sigma - 1)*params.by_ratio;
systemMats.A0(vrbs.b_m, vrbs.P_m) = -(params.rho/params.gamma - 1)*params.by_ratio;
systemMats.A0(vrbs.b_m, vrbs.tau) = 1;
systemMats.A0(vrbs.b_m, vrbs.g) = -params.gy_ratio;

%% k - State
systemMats.A0(vrbs.k,vrbs.k)=1;
systemMats.A7(vrbs.k,vrbs.k)=(1-params.delta)*params.gamma^(-1);
systemMats.A0(vrbs.k,vrbs.gamma)=(1-params.delta)*params.gamma^(-1);
systemMats.A0(vrbs.k,vrbs.mu)=-params.ik_ratio;
systemMats.A0(vrbs.k,vrbs.i)=-params.ik_ratio;

%% y - Jump
systemMats.A0(vrbs.y, vrbs.y) = 1;
systemMats.A0(vrbs.y, vrbs.c) = -params.cy_ratio;
systemMats.A0(vrbs.y, vrbs.i) = -params.iy_ratio;
systemMats.A0(vrbs.y, vrbs.g) = -params.gy_ratio;
systemMats.A0(vrbs.y, vrbs.R_k) = -params.R_K * params.gamma^(-1) / params.yk_ratio * params.xi_a^(-1);

%% SHOCKS %%

%% TFP shock
systemMats.A0(vrbs.gamma,vrbs.gamma)=1;
systemMats.A7(vrbs.gamma,vrbs.gamma)=params.rho_gamma;
systemMats.A8(vrbs.gamma,shocks.gamma)=params.sigma_gamma;

%% labor supply shock
systemMats.A0(vrbs.theta_w,vrbs.theta_w)=1;
systemMats.A7(vrbs.theta_w,vrbs.theta_w)=params.rho_theta_w;
systemMats.A8(vrbs.theta_w,shocks.theta_w)=params.sigma_theta_w;

%% Investment shock
systemMats.A0(vrbs.mu,vrbs.mu)=1;
systemMats.A7(vrbs.mu,vrbs.mu)=params.rho_mu;
systemMats.A8(vrbs.mu,shocks.mu)=params.sigma_mu;

%% government spending shock
systemMats.A0(vrbs.g,vrbs.g)=1;
systemMats.A7(vrbs.g,vrbs.g)=params.rho_g;
systemMats.A8(vrbs.g,shocks.g)=params.sigma_g;

%% preferences shock
systemMats.A0(vrbs.xi,vrbs.xi)=1;
systemMats.A7(vrbs.xi,vrbs.xi)=params.rho_xi;
systemMats.A8(vrbs.xi,shocks.xi)=params.sigma_xi;

%% Inflation target shock
systemMats.A0(vrbs.pistar,vrbs.pistar)=1;
systemMats.A7(vrbs.pistar,vrbs.pistar)=params.rho_pistar;
systemMats.A8(vrbs.pistar,shocks.pistar)=params.sigma_pistar;

%% cost-push shock
systemMats.A0(vrbs.theta_p,vrbs.theta_p)=1;
systemMats.A7(vrbs.theta_p,vrbs.theta_p)=params.rho_theta_p;
systemMats.A8(vrbs.theta_p,shocks.theta_p)=params.sigma_theta_p;

%% policy shock
systemMats.A0(vrbs.m,vrbs.m)=1;
systemMats.A7(vrbs.m,vrbs.m)=params.rho_m;
systemMats.A8(vrbs.m,shocks.m)=params.sigma_m;

%% tax shock
systemMats.A0(vrbs.tau_shock,vrbs.tau_shock)=1;
systemMats.A7(vrbs.tau_shock,vrbs.tau_shock)=params.rho_tau_hat;
systemMats.A8(vrbs.tau_shock,shocks.tau)=params.sigma_tau_hat;


%% Remove lag variables as states (they are not necessary)
if nlag>0
    remove_inds=nvar-nlag+1:nvar;
end

systemMats.A0(remove_inds,:)=[];systemMats.A0(:,remove_inds)=[];
systemMats.A1(remove_inds,:)=[];systemMats.A1(:,remove_inds)=[];
systemMats.A2(remove_inds,:)=[];systemMats.A2(:,remove_inds)=[];
systemMats.A3(remove_inds,:)=[];systemMats.A3(:,remove_inds)=[];
systemMats.A4(remove_inds,:)=[];systemMats.A4(:,remove_inds)=[];
systemMats.A5(remove_inds,:)=[];systemMats.A5(:,remove_inds)=[];
systemMats.A6(remove_inds,:)=[];systemMats.A6(:,remove_inds)=[];
systemMats.A7(remove_inds,:)=[];systemMats.A7(:,remove_inds)=[];
systemMats.A8(remove_inds,:)=[];

% save 6 discount factors as one vector
lambda=[lambda_1 lambda_2 lambda_3 lambda_4 lambda_5 lambda_6];


